/** 
 * emojiarea - A rich textarea control that supports emojis, WYSIWYG-style.
 * Copyright (c) 2012 DIY Co
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this 
 * file except in compliance with the License. You may obtain a copy of the License at:
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under 
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF 
 * ANY KIND, either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 *
 * @author Brian Reavis <brian@diy.org>
 */
(function($, window, document) {

    var ELEMENT_NODE = 1;
    var TEXT_NODE = 3;
    var TAGS_BLOCK = ['p', 'div', 'pre', 'form'];
    var KEY_ESC = 27;
    var KEY_TAB = 9;
    var EMOJI_ACTIVE_TAB = 'emoticons';
	var IS_STICKERS;
	var _emoji_this;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    $.emojiarea = {
        path: '',
        icons: {},
        defaults: {
			stickers:true,
            button: null,
            buttonLabel: 'Emojis',
            buttonPosition: 'after'
        }
    };

    $.fn.emojiarea = function(options) {
        options = $.extend({}, $.emojiarea.defaults, options);
        return this.each(function() {
            var $textarea = $(this);
            if ('contentEditable' in document.body && options.wysiwyg !== false) {
                new EmojiArea_WYSIWYG($textarea, options);
            } else {
                new EmojiArea_Plain($textarea, options);
            }
        });
    };

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    var util = {};

    util.restoreSelection = (function() {
        if (window.getSelection) {
            return function(savedSelection) {
                var sel = window.getSelection();
                sel.removeAllRanges();
                for (var i = 0, len = savedSelection.length; i < len; ++i) {
                    sel.addRange(savedSelection[i]);
                }
            };
        } else if (document.selection && document.selection.createRange) {
            return function(savedSelection) {
                if (savedSelection) {
                    savedSelection.select();
                }
            };
        }
    })();

    util.saveSelection = (function() {
        if (window.getSelection) {
            return function() {
                var sel = window.getSelection(),
                    ranges = [];
                if (sel.rangeCount) {
                    for (var i = 0, len = sel.rangeCount; i < len; ++i) {
                        ranges.push(sel.getRangeAt(i));
                    }
                }
                return ranges;
            };
        } else if (document.selection && document.selection.createRange) {
            return function() {
                var sel = document.selection;
                return (sel.type.toLowerCase() !== 'none') ? sel.createRange() : null;
            };
        }
    })();

    util.replaceSelection = (function() {
        if (window.getSelection) {
            return function(content) {
                var range, sel = window.getSelection();
                var node = typeof content === 'string' ? document.createTextNode(content) : content;
                if (sel.getRangeAt && sel.rangeCount) {
                    range = sel.getRangeAt(0);
                    range.deleteContents();
                    range.insertNode(document.createTextNode(' '));
                    range.insertNode(node);
                    range.setStart(node, 0);

                    window.setTimeout(function() {
                        range = document.createRange();
                        range.setStartAfter(node);
                        range.collapse(true);
                        sel.removeAllRanges();
                        sel.addRange(range);
                    }, 0);
                }
            }
        } else if (document.selection && document.selection.createRange) {
            return function(content) {
                var range = document.selection.createRange();
                if (typeof content === 'string') {
                    range.text = content;
                } else {
                    range.pasteHTML(content.outerHTML);
                }
            }
        }
    })();

    util.insertAtCursor = function(text, el) {
        text = ' ' + text;
        var val = el.value,
            endIndex, startIndex, range;
        if (typeof el.selectionStart != 'undefined' && typeof el.selectionEnd != 'undefined') {
            startIndex = el.selectionStart;
            endIndex = el.selectionEnd;
            el.value = val.substring(0, startIndex) + text + val.substring(el.selectionEnd);
            el.selectionStart = el.selectionEnd = startIndex + text.length;
        } else if (typeof document.selection != 'undefined' && typeof document.selection.createRange != 'undefined') {
            el.focus();
            range = document.selection.createRange();
            range.text = text;
            range.select();
        }
    };

    util.extend = function(a, b) {
        if (typeof a === 'undefined' || !a) {
            a = {};
        }
        if (typeof b === 'object') {
            for (var key in b) {
                if (b.hasOwnProperty(key)) {
                    a[key] = b[key];
                }
            }
        }
        return a;
    };

    util.escapeRegex = function(str) {
        return (str + '').replace(/([.?*+^$[\]\\(){}|-])/g, '\\$1');
    };

    util.htmlEntities = function(str) {
        return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
    };

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    var EmojiArea = function() {};

    EmojiArea.prototype.setup = function() {
        var self = this;

        this.$editor.on('focus', function() {
            self.hasFocus = true;
        });
        this.$editor.on('blur', function() {
            self.hasFocus = false;
        });

        this.setupButton();
    };

    EmojiArea.prototype.setupButton = function() {
		var randTime = (new Date()).getTime();
        var self = this;
        var $button, $em_cont_btn,
		$button_media = ga('<a/>').addClass('comments_attach_trigger_ic'),
		$p_button_media = ga('<div/>').addClass('ms_items_more_wrap to_up media_selector __inline');
		$p_button_media.html($button_media);
		//'<a class="comments_attach_trigger_ic"></a>';

        if (this.options.button) {
            $button = $(this.options.button);
			$button.before($p_button_media);
        } else if (this.options.button !== false) {
	    $em_cont_btn = ga('<div/>').addClass('emoj_button_show_sm');
            $button = ga('<a href="javascript:void(0)">');
            $button.html(this.options.buttonLabel);
            $button.addClass('emoji-button');
            $button.attr({
                title: this.options.buttonLabel
            });
            this.$editor[this.options.buttonPosition]($button);
			this.$editor[this.options.buttonPosition]($p_button_media);
        } else {
            $button = ga('');
        }
		
		$button_media.on('click', function(e){  
		e.preventDefault();
		e.stopPropagation();
		var $t = ga(this);
		var $p_t = $t.parent();
		var getPostId = $t.closest('.messenger').length ? 'messenger_'+$t.closest('.messenger').find('#chat_id').val() : parseInt($t.closest('[data-wdcommid]').data('wdcommid'));
		var postIdForTracks = $t.closest('.disc_toolbar_i').length ? 'PM' : ($t.closest('.chat_bottom_ics').length ? $t.closest('.chat_bottom_ics').data('chat-id') : getPostId );
		var g_send_in = $t.closest('#chatmwrite').length ? 'chat' : 
						$t.closest('.mdialog_chat_add-comment').length ? 'PM' : 
						$t.closest('.feed_post_comments_widget').length ? 'feed_comments' : 
						$t.closest('#movie-comments').length ? 'video' : 
						$t.closest('#postViewerCommentsSection').length ? 'post' : 
						$t.closest('.photo_layer_bottom_com').length ? 'photo' : 
						$t.closest('.mob_feed_post_comments_widget').length ? $t.closest('.mob_feed_post_comments_widget').attr('postcomments-item-type') : '';
		
		
		var $btn_more_markup = '<div class="ms_items_more_helper">\
											<div class="ms_items_more _more_items">\
											<a class="ms_item ms_item_gif _type_gif" data-send-to-id="'+getPostId+'" data-send-in="'+g_send_in+'" onclick="searchGIF(this,event,\''+getPostId+'\');" tabindex="0">'+lang.dropdown_gif+'</a>\
											<a class="ms_item ms_item_video _type_video" style="display:none;" tabindex="0">'+lang.add_video+'</a>\
											<a class="ms_item ms_item_audio _type_audio" onclick="commAttachTracks(event,this,\''+postIdForTracks+'\');" tabindex="0">'+lang.add_tracks+'</a>\
											<a class="ms_item ms_item_photo _type_photo" onclick="attach_pPhoto(event,0,\''+getPostId+'\');" tabindex="0">'+lang.photo+'</a>\
											<a class="ms_item ms_item_doc _type_photo_from_computer" onclick="attach_pPhoto(event,1,\''+getPostId+'\');" tabindex="0">'+lang.photo_computer+'</a>\
											</div>\
								</div>';
								
			ga('.ms_items_more_helper').fadeOut();
			$p_t.addClass('shown');				
			if ( !$p_t.find('.ms_items_more_helper').length ) $t.parent().prepend($btn_more_markup);
					else 
						$p_t.find('.ms_items_more_helper').show();
					
					
			// check if element is visible in viewport
			if( !isElementInViewport( $p_t.find('.ms_items_more'),0,0 ) ) $p_t.removeClass('to_up').addClass('to_down');
			else  $p_t.addClass('to_up').removeClass('to_down');
				
								
		});
		var closeMediaMenu = function(){
			ga('.ms_items_more_helper').fadeOut();
		};
		// close media menu by click out
		ga('html,body').off('click.closeMediaMenu'+randTime).on('click.closeMediaMenu'+randTime, function(e){
			closeMediaMenu();	
		});
		
		// close media menu by pressing ESC
		ga('html,body').off('keyup.closeMediaMenu'+randTime).on('keyup.closeMediaMenu'+randTime, function(e){
		if(e.keyCode == 27) {closeMediaMenu();}
			
		});
        $button.on('click', function(e) {
            EmojiMenu.show(self,$button);
            e.stopPropagation();
			closeMediaMenu();
        });

        this.$button = $button;
    };

    EmojiArea.createIcon = function( emoji, returnWH, s_cn, s_kn ) {
	
	var w,h;
	var emoji_ic_size = 0;
        var filename = !IS_STICKERS ? $.emojiarea.icons[EMOJI_ACTIVE_TAB][emoji] : $.emojiarea.icons[EMOJI_ACTIVE_TAB][IS_STICKERS][emoji];
		
        var path = $.emojiarea.path[EMOJI_ACTIVE_TAB] || '';
        if (path.length && path.charAt(path.length - 1) !== '/') {
            path += '/';
        }
 
/*	if(returnWH){

  var newImg = new Image();

    newImg.onload = function() {
      h = newImg.height;
      w = newImg.width;

    }

    newImg.src = path + filename; // this must be done AFTER setting onload

	return [w,h];
	}
*/
/*
		switch (s_cn){
			
			case 27:
			emoji_ic_size = 26;
			break;
			case (27*2):
			emoji_ic_size = 26*2;
			break;
			
		}*/
		//if(s_cn === 27) {emoji_ic_size = 26*x_cn; s_cn = 0;}
		
		if(EMOJI_ACTIVE_TAB === 'emoticons'){
        return typeof s_cn == 'number' ? '<img src="'+_THEME+'/css/images/b/blank.gif" style="background-position: -'+ (s_cn * 26) +'px -'+(s_kn*26)+'px" class="emotics emoji-spritesheet-0 emoji-w26 emoji-code-bg-kn_'+filename+'" alt="'+util.htmlEntities(emoji)+'">' : 
										 '<img src="'+_THEME+'/css/images/b/blank.gif" class="emotics emoji-spritesheet-0 emoji-code-bg-kn_'+filename+'" alt="'+util.htmlEntities(emoji)+'">';//'<img src="' + path + filename + '" alt="' + util.htmlEntities(emoji) + '">';
		}else if (EMOJI_ACTIVE_TAB === 'sticker'){
			
			var sticker_name = IS_STICKERS;
			
			return '<img src="'+_THEME+'/css/images/b/blank.gif" class="sticker '+sticker_name+' sticker-spritesheet-0 sticker-code-bg-kn_'+filename+'" alt="'+util.htmlEntities(emoji)+'">';
			
		}else {
			return '<img src="' + path + filename + (EMOJI_ACTIVE_TAB === 'y_smilies' ? '.gif' : '') + '" alt="' + util.htmlEntities(emoji) + '" />';
		}
	 };

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    /**
     * Editor (plain-text)
     * 
     * @constructor
     * @param {object} $textarea
     * @param {object} options
     */

    var EmojiArea_Plain = function($textarea, options) {
        this.options = options;
        this.$textarea = $textarea;
        this.$editor = $textarea;
        this.setup();
    };

    EmojiArea_Plain.prototype.insert = function(emoji) {
        if (!$.emojiarea.icons.hasOwnProperty(emoji)) return;
        util.insertAtCursor(emoji, this.$textarea[0]);
        this.$textarea.trigger('change');
    };

    EmojiArea_Plain.prototype.val = function() {
        return this.$textarea.val();
    };

    util.extend(EmojiArea_Plain.prototype, EmojiArea.prototype);

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    /**
     * Editor (rich)
     * 
     * @constructor
     * @param {object} $textarea
     * @param {object} options
     */

    var EmojiArea_WYSIWYG = function($textarea, options) {
        var self = this;

        this.options = options;
        this.$textarea = $textarea;
        this.$editor = $('<div>').addClass('emoji-wysiwyg-editor');
        this.$editor.text($textarea.val());
        this.$editor.attr({
            contenteditable: 'true'
        });
        this.$editor.on('blur keyup paste', function() {
            return self.onChange.apply(self, arguments);
        });
        this.$editor.on('mousedown focus', function() {
            document.execCommand('enableObjectResizing', false, false);

        });

	this.$editor.on('blur', function() {
            document.execCommand('enableObjectResizing', true, true);
        });

        var html = this.$editor.text();
        var emojis = $.emojiarea.icons;
        for (var key in emojis) {
            if (emojis.hasOwnProperty(key)) {
                html = html.replace(new RegExp(util.escapeRegex(key), 'g'), EmojiArea.createIcon(key));
            }
        }
        this.$editor.html(html);

        $textarea.hide().after(this.$editor);

        this.setup();

        this.$button.on('mousedown', function() {
            if (self.hasFocus) {
                self.selection = util.saveSelection();
            }
        });
    };

    EmojiArea_WYSIWYG.prototype.onChange = function() {
        this.$textarea.val(this.val()).trigger('change');
    };

    EmojiArea_WYSIWYG.prototype.insert = function(emoji) {
        var content; 
        var $img = $(EmojiArea.createIcon(emoji));
        if ($img[0].attachEvent) {
            $img[0].attachEvent('onresizestart', function(e) {
                e.returnValue = false;
            }, false);
        }

        this.$editor.trigger('focus');
        if (this.selection) {
            util.restoreSelection(this.selection);
        }
        try {
            util.replaceSelection($img[0]);
        } catch (e) {}
        this.onChange();
    };

    EmojiArea_WYSIWYG.prototype.val = function() {
        var lines = [];
        var line = [];

        var flush = function() {
            lines.push(line.join(''));
            line = [];
        };

        var sanitizeNode = function(node) {
            if (node.nodeType === TEXT_NODE) {
                line.push(node.nodeValue);
            } else if (node.nodeType === ELEMENT_NODE) {
                var tagName = node.tagName.toLowerCase();
                var isBlock = TAGS_BLOCK.indexOf(tagName) !== -1;

                if (isBlock && line.length) flush();

                if (tagName === 'img') {
                    var alt = node.getAttribute('alt') || '';
                    if (alt) line.push(alt);
                    return;
                } else if (tagName === 'br') {
                    flush();
                }

                var children = node.childNodes;
                for (var i = 0; i < children.length; i++) {
                    sanitizeNode(children[i]);
                }

                if (isBlock && line.length) flush();
            }
        };

        var children = this.$editor[0].childNodes;
        for (var i = 0; i < children.length; i++) {
            sanitizeNode(children[i]);
        }

        if (line.length) flush();

        return lines.join('\n');
    };

    util.extend(EmojiArea_WYSIWYG.prototype, EmojiArea.prototype);

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    /**
     * Emoji Dropdown Menu
     *
     * @constructor
     * @param {object} emojiarea
     */
    var EmojiMenu = function($btn,opts) {
        var self = this;
        var $body = ga(document.body);
        var $window = ga(window);
		EMOJIOP = self;
        this.visible = false;
        this.emojiarea = null;
        this.$menu = ga('<div>');
        this.$menu.addClass('emoji-menu');
        this.$menu.hide();
		var _emj_nano_a = ga('<div/>').addClass('emoj_sm_cont nano').appendTo(this.$menu);
        this.$items = ga('<div/>').addClass('nano-content').appendTo(_emj_nano_a);//this.$menu);
		
 
		
		//this.$items_a.html('<div class="nano-content"></div>');
		//this.$items_b = ga(this.$items_a).find('')
		//this.$items = this.$items_a;
	//$('<div class="sm_tab_top"><ul class="emoji_tabs"><li><div class="emoticon_ic"></div></li><li><div class="meep_ic"></div></li></ul></div>').prependTo(this.$menu);

	var stickers = opts.stickers ? '<a href="javascript:;" rel="tipsy" title="Hacker Boy" data-tb="sticker" data-sticker="hacker-boy" class="js-tabs-t js-custom-smiles comments_smiles_tabs_i __stickers __mod"><div class="comments_smiles_tabs_ic __stickers __hackerboy"></div></a>\
					<a href="javascript:;" rel="tipsy" title="Cute cat" data-tb="sticker" data-sticker="cute-cat" class="js-tabs-t js-custom-smiles comments_smiles_tabs_i __stickers __mod"><div class="comments_smiles_tabs_ic __stickers __cutecat"></div></a>' : '';
ga('<div class="comments_smiles_tabs">\
<a href="javascript:;" rel="tipsy" title="Smiley Faces" data-tb="y_smilies" class="js-tabs-t comments_smiles_tabs_i __current"><div class="comments_smiles_tabs_ic __y"></div></a>\
<a href="javascript:;" rel="tipsy" title="Emoticons" data-tb="emoticons" class="js-tabs-t comments_smiles_tabs_i"><div class="comments_smiles_tabs_ic __globalsmilies"></div></a>\
'+stickers+'\
</div>').prependTo(this.$menu);

        //$body.append(this.$menu).find('.comments_smiles_tabs_i').on('click',function(e){

  $btn.parent().append(this.$menu).find('.comments_smiles_tabs_i').off('click.smilies_tab').on('click.smilies_tab',function(e){
 e.preventDefault();
e.stopImmediatePropagation();
var curCSSclass = '__current'; 
ga(this).parent().find('.'+curCSSclass).removeClass(curCSSclass);
ga(this).addClass(curCSSclass);

EMOJI_ACTIVE_TAB = ga(this).data('tb');
IS_STICKERS = ga(this).hasClass('__stickers') ? ga(this).data('sticker') : false;
emojiNano();
self.load(self);
});
       if(EMOJI_ACTIVE_TAB !== 'y_smilies'){
	ga('[data-tb="'+EMOJI_ACTIVE_TAB+'"]').trigger('click');
	}

        $body.off('keydown.closeEmojiSm').on('keydown.closeEmojiSm', function(e) {
            if (e.keyCode === KEY_ESC || e.keyCode === KEY_TAB) {
                self.hide();
				e.stopPropagation();
            }
        });

        $body.off('mouseup.closeEmojiSm').on('mouseup.closeEmojiSm', function() {
          self.hide();
        });

        $window.on('resize', function() {
            if (self.visible) self.reposition();
        });

        this.$menu.on('mouseup', function(e) {
            e.stopPropagation();
            return false;
        });

        this.$menu.on('click', 'a', function(e) {
            var emoji = $('.label', $(this)).text();
			var _this = ga(this);
			_emoji_this = _this;
            window.setTimeout(function() {
               self.onItemSelected.apply(self, [emoji]);
            }, 0);
            e.stopPropagation();
            return false;
        });

        this.load();
    };

    EmojiMenu.prototype.onItemSelected = function(emoji) {
        this.emojiarea.insert(emoji);
        //this.hide();
    };
   
    EmojiMenu.prototype.load = function() {
        var html = [], sm_c = EMOJI_ACTIVE_TAB === 'emoticons' ? 0 : false, sn_c = EMOJI_ACTIVE_TAB === 'emoticons' ? 0 : false;
        var options = !IS_STICKERS ? $.emojiarea.icons[EMOJI_ACTIVE_TAB] : $.emojiarea.icons[EMOJI_ACTIVE_TAB][IS_STICKERS];//t_meep ? emoji_meep : $.emojiarea.icons;
        var path = $.emojiarea.path[EMOJI_ACTIVE_TAB];///t_meep ? meep_path : $.emojiarea.path; 
 
        if (path.length && path.charAt(path.length - 1) !== '/') {
            path += '/';
        }

		
		var $t = ga('.comments_smiles_tabs_ic.__stickers');
		var in_community = $t.closest('.incommunity').length ? 1 : 0;
		var getPostId = $t.closest('.messenger').length ? 'messenger_'+$t.closest('.messenger').find('#chat_id').val() : parseInt($t.closest('[data-wdcommid]').data('wdcommid'));
		var postIdForTracks = $t.closest('.disc_toolbar_i').length ? 'PM' : ($t.closest('.chat_bottom_ics').length ? $t.closest('.chat_bottom_ics').data('chat-id') : getPostId );
		var g_send_in = $t.closest('#chatmwrite').length ? 'chat' : 
						$t.closest('.mdialog_chat_add-comment').length ? 'PM' : 
						$t.closest('.feed_post_comments_widget').length ? 'feed_comments' : 
						$t.closest('#movie-comments').length ? 'video' : 
						$t.closest('#postViewerCommentsSection').length ? 'post' : 
						$t.closest('.photo_layer_bottom_com').length ? 'photo' : 
						$t.closest('.mob_feed_post_comments_widget').length ? $t.closest('.mob_feed_post_comments_widget').attr('postcomments-item-type') : '';
		
		var is_in_new_post = $t.closest('#main_ff_share').length ? 1 : 0; 
		
        for (var key in options) { 
            if (options.hasOwnProperty(key)) {
                var filename = options[key];
 
				html.push('<a class="'+ (EMOJI_ACTIVE_TAB === 'y_smilies' ? 'ysm' : '') +'" href="javascript:void(0)" '+(EMOJI_ACTIVE_TAB === 'sticker' && !is_in_new_post ? 'data-sticker-code="' + util.htmlEntities(key) + '" data-send-to-id="'+getPostId+'" data-send-in="'+g_send_in+'" onclick="event.preventDefault(); event.stopPropagation(); return sendSticker(this,event,'+in_community+')"' : '')+' title="' + util.htmlEntities(key) + '">'+EmojiArea.createIcon(key,false,sm_c,sn_c)+'<span class="label">' + util.htmlEntities(key) + '</span></a>');
			}
 
		if(EMOJI_ACTIVE_TAB === 'emoticons'){	
		if( sm_c === 26 ) {sm_c = 0; sn_c++;} else { ++sm_c;}
		}

 
			
        }

        this.$items.html(html.join(''));
    };

    EmojiMenu.prototype.reposition = function() {
        var $button = this.emojiarea.$button;
        var offset = $button.offset();
	var pos = $button.position();
        offset.top += $button.outerHeight();
        offset.left += Math.round($button.outerWidth());

        pos.top += $button.outerHeight();
        pos.left += Math.round($button.outerWidth());
        /*this.$menu.css({
            top: pos.top,//pos.top - 110,
            left:pos.left ///pos.left
        });*/
		
		
    };

    EmojiMenu.prototype.hide = function(callback) {
        /*if (this.emojiarea) {
            this.emojiarea.menu = null;
            this.emojiarea.$button.removeClass('on');
            this.emojiarea = null;
        }
        this.visible = false;
        this.$menu.hide();*/
	this.$menu.remove();
	//ga('body').removeClass(_nscroll);
	var $body = ga('body');
	
	if($body.hasClass('add-noscroll-after-close-emoji')) {$body.removeClass('add-noscroll-after-close-emoji');$body.addClass('noscroll');ga(window).scrollTop(0);} 
	
    };

    EmojiMenu.prototype.show = function(emojiarea) {
/*        if (this.emojiarea && this.emojiarea === emojiarea) return;
        this.emojiarea = emojiarea;
        this.emojiarea.menu = this;

        this.reposition();
        this.$menu.show();
        this.visible = true;*/

//if(!EMOJI_TH_IT.parent().find('.emoji-menu').length){
///EmojiMenu();
//}else{

        //this.emojiarea.menu = menu;
        this.emojiarea = emojiarea;
 this.$menu.show();
 var $body = ga('body');
// ga('body').addClass(_nscroll);emojiNano();
var is_messenger = ga('.messenger__write');
 if (!is_messenger.length && !isElementInViewport(this.$menu,0,100) ) this.$menu.addClass('_bottom');
  if (is_messenger.length) { if($body.hasClass('noscroll')) {$body.removeClass('noscroll');$body.addClass('add-noscroll-after-close-emoji');}  this.$menu.addClass('_topmessenger');}
 
///}
    };

    EmojiMenu.show = (function() {
        var menu = null;
        return function(emojiarea,$btn) {  
            menu = new EmojiMenu($btn,emojiarea.options);
 
            menu.show(emojiarea);
        };
    })();

})(jQuery, window, document);

function emojiNano(){
	//setTimeout(function(){ga('.emoj_sm_cont.nano').nanoScroller();},10);
}